<section class="mentor-showcase bg-light-gradient py-6">
    <div class="container">
        <div class="text-center mx-auto mb-5 section-heading">
            <h2 class="h1 font-weight-bold mb-3"><?php echo trans('mentors') ?></h2>
            <p class="lead mb-0">Find the perfect mentor to accelerate your growth journey</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="search-box br-10 shadow-sm mb-5">
                    <form method="GET" enctype="multipart/form-data" class="mentor_search_form p-4" action="<?php echo base_url('home/mentor_search') ?>" role="form">
                        <div class="row g-3 align-items-center">
                            <div class="col-lg-3 col-md-6 mb-3">
                                <label class="form-label fw-500"><?php echo trans('search') ?></label>
                                <div class="form-group has-search">
                                    <div class="search-input-wrapper">
                                        <span class="search-icon"><i class="bi bi-search"></i></span>
                                        <input type="text" class="form-control search-input search_name" placeholder="<?php echo trans('search-by-name') ?>" name="mentor_search_name">
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-2 col-md-6 mb-3">
                                <label class="form-label fw-500"><?php echo trans('categories') ?></label>
                                <div class="form-group">
                                    <select name="category" id="search_category" class="form-control sort_front custom-select search_category">
                                        <option value=""> <?php echo trans('all-categories') ?></option>
                                        <?php foreach ($categories as $category): ?>
                                            <option <?php if((isset($_GET['categories']) || isset($_GET['search_category'])) && (isset($_GET['search_category']) && $_GET['search_category'] == $category->id || isset($_GET['categories']) && $_GET['categories'] == $category->id || isset($_GET['categories']) && $_GET['categories'] == $category->slug)){echo "selected";} ?> value="<?php echo html_escape($category->id)?>"> <?php echo html_escape($category->name)?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-2 col-md-6 mb-3">
                                <label class="form-label fw-500"><?php echo trans('skills') ?></label>
                                <div class="form-group">
                                    <select name="mentor_search_skill" class="form-control sort_front custom-select" id="search_skills">                
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-2 col-md-6 mb-3">
                                <label class="form-label fw-500"><?php echo trans('experience') ?></label>
                                <div class="form-group">
                                    <select name="mentor_search_experience" class="form-control sort_front custom-select">
                                        <option value=""><?php echo trans('any-experience') ?></option>
                                        <?php for ($i=1 ; $i <31; $i++ ): ?>
                                            <option <?php if(isset($_POST['mentor_search_experience']) && $_POST['mentor_search_experience'] == $i){echo "selected";} ?> value="<?php echo html_escape($i); ?>"><?php echo html_escape($i); ?> <?php echo trans('year') ?><?php if($i > 1) echo 's'; ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-2 col-md-6 mb-3">
                                <label class="form-label fw-500"><?php echo trans('country') ?></label>
                                <div class="form-group">
                                    <select name="mentor_search_country" class="form-control sort_front custom-select">
                                        <option value=""><?php echo trans('all-countries') ?></option>
                                        <?php foreach ($countries as $country): ?>
                                            <option value="<?php echo html_escape($country->id) ?>" <?php if(isset($_POST['mentor_search_country']) && $_POST['mentor_search_country'] == $country->id){echo 'selected';} ?>><?php echo html_escape($country->name) ?></option>
                                        <?php endforeach ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-lg-1 col-md-6">
                                <button type="submit" class="btn btn-primary btn-block search-btn"><i class="bi bi-search"></i></button>
                                <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php if(!empty($mentors)): ?>
            <div class="row mentor_area justify-content-center">
                <?php include APPPATH.'views/include/mentor_card_new.php'; ?> 
            </div>
        <?php else: ?>
            <div class="no-results">
                <div class="no-results-content text-center">
                    <!--<img src="<?php echo base_url('assets/images/no-results.svg') ?>" alt="No results" class="mb-4">-->
                    <h4 class="mb-3"><?php echo trans('no-data-found') ?></h4>
                    <p class="text-muted">Try adjusting your search criteria or browse all mentors</p>
                    <!--<a href="<?php echo base_url('mentors') ?>" class="btn btn-outline-primary mt-3">-->
                    <!--    <i class="bi bi-grid me-2"></i> <?php echo trans('view-all-mentors') ?>-->
                    <!--</a>-->
                </div>
            </div>
        <?php endif; ?>

        <div class="col-12 text-center mt-5">
            <?php echo $this->pagination->create_links(); ?>
        </div>
    </div>

    <div class="hero-bg-shape-1"></div>
    <div class="hero-bg-shape-2"></div>
</section>