<div class="login-bg login-main-container d-none d-lg-block bg-light"> </div>

<div class="d-flex align-items-center position-relative min-vh-100">
    
    <!-- Login form -->
    <div class="container">
        <div class="row justify-content-center justify-content-lg-start">
            
            <div class="col-md-5 p-5 mx-auto my-5" data-aos="fade-up" data-aos-duration="400">
                <div class="shadow rounded bg-white py-6 px-6 border-0" id="login-area">

                    <?php if (isset($_GET['msg']) && $_GET['msg'] == 'success'): ?>
                        <div class="alert alert-success alert-dismissible mb-4 log_alert">
                          <button type="button" class="close" data-dismiss="alert"><i class="bi bi-x"></i></button>
                          <?php echo trans('logout-successfully-') ?>
                        </div>
                    <?php endif ?>

                    <div class="mb-6 text-center">
                        <?php get_last_logins(); ?>
                        <h4 class="font-weight-bold mb-2"><a href="<?php echo base_url() ?>"><img class="w-60" src="<?php echo base_url(settings()->logo) ?>"></a></h4>
                        <p class="mb-0 mt-2"><?php echo trans('sign-in-to-your') ?> <?php echo trans('account') ?></p>
                    </div>

                    <div class="mb-4 mt-4">
                        <div class="success text-success"></div>
                        <div class="error text-danger"></div>
                        <div class="warning text-warning"></div>
                    </div>

                    <?php if (settings()->type == 'demo'): ?>
                    <div class="alert alert-default mb-4">
                        <div class="rows badge badge-pill bg-primary-soft">
                            <div class="col-6 mb-2">
                                admin
                            </div>
                            <div class="col-6">
                                1234
                            </div>
                        </div>
                        <div class="rows badge badge-pill bg-primary-soft">
                            <div class="col-6 mb-2">
                                mentor
                            </div>
                            <div class="col-6">
                                1234
                            </div>
                        </div>
                        <div class="rows badge badge-pill bg-primary-soft">
                            <div class="col-6 mb-2">
                                mentee
                            </div>
                            <div class="col-6">
                                1234
                            </div>
                        </div>
                    </div>
                    <?php endif ?>

                    <form id="login-form" method="post" action="<?php echo base_url('auth/log'); ?>">

                        <div class="row">
                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <label><?php echo trans('user-name') ?></label>
                                    <input type="text" class="form-control" name="user_name" placeholder="<?php echo trans('enter-email-or-username') ?>" autocomplete="off">
                                </div>
                            </div>

                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <label><?php echo trans('password') ?></label>
                                    <input type="password" class="form-control" name="password" placeholder="<?php echo trans('enter-password') ?>" autocomplete="off">
                                </div>

                                <div class="text-left text-sm-left">
                                    <a href="#" class="m-link-muted small forgot_pass text-dark"><?php echo trans('forgot-password') ?></a>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            
                            <div class="col-md-12 center">
                                <!-- csrf token -->
                                <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name());?>" value="<?php echo html_escape($this->security->get_csrf_hash());?>">
                                <button type="submit" class="btn btn-primary btn-block mt-4 mb-0 signin_btn"><?php echo trans('sign-in') ?> </button>
                            </div>

                            <div class="col-md-12 center">
                                <?php if (get_system_settings('enable_google') == 1): ?>
                                    <div class="py-3 w-50 m-auto or"><span>or</span></div>
                                <?php endif ?>
                            </div>

               
                            <div class="col-md-12 center">
                                <?php
                                if($google_url && get_system_settings('enable_google') == 1):
                                ?>
                                    <div class="form-group mb-3">
                                        <a href="#" data-toggle="modal" data-target="#googleAuthModal" class="btn btn-block w-100 d-flex align-items-center justify-content-center" style="gap: 10px;background: #F1F1F1;padding:0.5rem 1.5rem!important;">
                                            <svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 48 48" width="35px" height="35px" style="width:unset;"><path fill="#FFC107" d="M43.611,20.083H42V20H24v8h11.303c-1.649,4.657-6.08,8-11.303,8c-6.627,0-12-5.373-12-12c0-6.627,5.373-12,12-12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C12.955,4,4,12.955,4,24c0,11.045,8.955,20,20,20c11.045,0,20-8.955,20-20C44,22.659,43.862,21.35,43.611,20.083z"/><path fill="#FF3D00" d="M6.306,14.691l6.571,4.819C14.655,15.108,18.961,12,24,12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C16.318,4,9.656,8.337,6.306,14.691z"/><path fill="#4CAF50" d="M24,44c5.166,0,9.86-1.977,13.409-5.192l-6.19-5.238C29.211,35.091,26.715,36,24,36c-5.202,0-9.619-3.317-11.283-7.946l-6.522,5.025C9.505,39.556,16.227,44,24,44z"/><path fill="#1976D2" d="M43.611,20.083H42V20H24v8h11.303c-0.792,2.237-2.231,4.166-4.087,5.571c0.001-0.001,0.002-0.001,0.003-0.002l6.19,5.238C36.971,39.205,44,34,44,24C44,22.659,43.862,21.35,43.611,20.083z"/>
                                            </svg> 
                                            <span>Continue with Google</span>
                                        </a>
                                    </div>
                                <?php
                                endif;
                                ?>
                            </div>

                            <?php if (settings()->enable_frontend == 0): ?>
                                <div class="col-md-12 center">
                                    <a href="<?php echo base_url('mentors') ?>" class="btn btn-outline-secondary btn-block mb-0"><i class="bi bi-person-circle"></i> <?php echo trans('mentors') ?> </a>
                                </div>
                            <?php endif ?>

                        </div>

                        <div class="text-center text-small mt-4">
                            <span><?php echo trans('an-account-yet') ?> <a href="<?php echo base_url('register') ?>"><?php echo trans('register') ?></a></span>
                        </div>

                    </form>
                </div>



                <div id="forgot-area" class="shadow-sm rounded bg-white py-6 px-8 border-0 d-hide">
                    
                    <div class="mb-6 text-center">
                        <h2 class="font-weight-bold mb-0"><a href="<?php echo base_url() ?>"><img width="30%" src="<?php echo base_url(settings()->logo) ?>"></a></h2>
                        <p class="font-weight-normal mb-0"><?php echo trans('recover-password') ?></p>
                    </div>

                    <!-- Form -->
                    <form id="lost-form" method="post" action="<?php echo base_url('auth/forgot_password'); ?>">

                        <div class="row d-none">
                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <select class="form-control" name="role" id="exampleFormControlSelect1">
                                        <option value=""><?php echo trans('select-your-role') ?></option>
                                        <option value="users"><?php echo trans('admin') ?></option>
                                        <option value="mentor"><?php echo trans('mentor').'/'.trans('mentee') ?></option>
                                        <option value="customers"><?php echo trans('customer') ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="email" required placeholder="<?php echo trans('enter-your-email') ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6 text-left text-sm-left">
                                <a href="#" class="small back_login"><i class="fas fa-long-arrow-left"></i> <?php echo trans('back') ?></a>
                            </div>
                            <div class="col-md-12 center">
                                <!-- csrf token -->
                                <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name());?>" value="<?php echo html_escape($this->security->get_csrf_hash());?>">
                                <button type="submit" id="forgot-submit-btn" class="btn btn-primary btn-block mt-4 mb-0"><?php echo trans('submit') ?></button>
                            </div>
                        </div>

                    </form>
                    <!-- End Form -->

                </div>

            </div>
        </div>
    </div>
    <!-- End Login form -->
   

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const lostForm = document.getElementById('lost-form');
    const submitBtn = document.getElementById('forgot-submit-btn');
    
    if (lostForm) {
        lostForm.addEventListener('submit', function(e) {
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<?php echo trans("submit") ?> <i class="fas fa-spinner fa-spin"></i>';
            setTimeout(function() {
                submitBtn.disabled = false;
                submitBtn.innerHTML = '<?php echo trans("submit") ?>';
            }, 10000); // 10 seconds 

            return true;
        });
    }
});
</script>

<div class="modal fade" id="googleAuthModal" tabindex="-1" role="dialog" aria-labelledby="googleAuthModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content border-0 shadow">
      <div class="modal-header border-0 py-3">
        <h5 class="modal-title" id="googleAuthModalLabel"><?php echo trans('choose_account_type') ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true"><i class="bi bi-x"></i></span>
        </button>
      </div>
      <div class="modal-body py-4">
        <p class="text-center text-muted mb-4"><?php echo trans('select') ?> <?php echo trans('account') ?> <?php echo trans('type') ?> <?php echo trans('to_continue') ?></p>
        
        <div class="row justify-content-center mb-4">
          <div class="col-md-5 mb-3">
            <div class="account-option" id="option-mentor">
              <input type="radio" id="account-mentor" name="account_type_modal" value="mentor" class="account-radio">
              <label for="account-mentor" class="account-label">
                <div class="icon-wrapper mb-3">
                  <i class="bi bi-person-workspace"></i>
                </div>
                <h6 class="mb-2"><?php echo trans('mentor') ?></h6>
                <p class="text-muted small mb-0">I want to provide mentoring and guidance</p>
              </label>
            </div>
          </div>
          <div class="col-md-5 mb-3">
            <div class="account-option" id="option-mentee">
              <input type="radio" id="account-mentee" name="account_type_modal" value="mentee" class="account-radio">
              <label for="account-mentee" class="account-label">
                <div class="icon-wrapper mb-3">
                  <i class="bi bi-person-badge"></i>
                </div>
                <h6 class="mb-2"><?php echo trans('mentee') ?></h6>
                <p class="text-muted small mb-0">I'm looking for guidance and mentorship</p>
              </label>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer border-0 justify-content-center pb-4">
        <a href="#" id="google_continue_btn" class="btn btn-primary btn-lg px-5 disabled">
          <div class="d-flex align-items-center">
            <span><?php echo trans('continue') ?></span>
            <i class="bi bi-arrow-right-short ml-2"></i>
          </div>
        </a>
      </div>
    </div>
  </div>
</div>

<style>
.account-option {
  position: relative;
  height: 100%;
}

.account-radio {
  position: absolute;
  opacity: 0;
  width: 0;
  height: 0;
}

.account-label {
  display: block;
  border: 2px solid #e9ecef;
  border-radius: 12px;
  padding: 1.5rem;
  cursor: pointer;
  transition: all 0.25s ease;
  text-align: center;
  height: 100%;
}

.icon-wrapper {
  font-size: 2rem;
  display: flex;
  align-items: center;
  justify-content: center;
  color: var(--primary-color);
}

.account-radio:checked + .account-label {
  border-color: var(--primary-color);
  background-color: rgba(var(--primary-rgb), 0.05);
  box-shadow: 0 0 0 3px rgba(var(--primary-rgb), 0.2);
  transform: translateY(-3px);
}

#google_continue_btn.disabled {
  opacity: 0.6;
  cursor: not-allowed;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const accountOptions = document.querySelectorAll('.account-radio');
  const continueBtn = document.getElementById('google_continue_btn');
  
  accountOptions.forEach(option => {
    option.addEventListener('change', function() {
      continueBtn.classList.remove('disabled');
      
      document.querySelectorAll('.account-option').forEach(opt => {
        opt.classList.remove('selected');
      });
      this.closest('.account-option').classList.add('selected');
    });
  });
  
  continueBtn.addEventListener('click', function(e) {
    e.preventDefault();
    
    if (this.classList.contains('disabled')) {
      return false;
    }
    
    const selectedType = document.querySelector('input[name="account_type_modal"]:checked');
    if (!selectedType) {
      return false;
    }
    
    this.innerHTML = '<div class="d-flex align-items-center"><span><?php echo trans('loading') ?>...</span><div class="spinner-border spinner-border-sm ml-2" role="status"><span class="sr-only">Loading...</span></div></div>';
    this.classList.add('disabled');
    
    const xhr = new XMLHttpRequest();
    xhr.open('GET', '<?php echo base_url() ?>auth/add_account_type/' + selectedType.value, true);
    xhr.onload = function() {
      if (xhr.status === 200) {
        window.location.href = '<?php echo $google_url ?>';
      }
    };
    xhr.send();
  });
});
</script>
