<?php foreach ($mentors as $mentor): ?>
 <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 px-0 slider-item">
    <div class="mentor-card">
        <div class="cards h-100">
            <a href="<?php echo base_url('mentor/'. $mentor->slug) ?>">
                <?php if (empty($mentor->image)): ?>
                    <?php $mentor_img = base_url('assets/images/no-photo-sm.png'); ?>
                <?php else: ?>
                    <?php $mentor_img = base_url($mentor->image); ?>
                <?php endif ?>
                <div class="uitem-bg" style="background-image: url(<?php echo $mentor_img; ?>)">
                    <?php if (!empty($mentor->respond_time) && $mentor->respond_in == 'hour'): ?>
                        <span class="available-badge" data-toggle="tooltip" data-title="<?php echo trans('available-asap') ?>">
                            <i class="bi bi-lightning-charge-fill text-white"></i>
                        </span>
                    <?php endif ?>

                    <?php if ($mentor->kyc_verified == 1): ?>
                        <span class="verified-badge" data-toggle="tooltip" data-title="<?php echo trans('kyc').' '.trans('verified') ?>">
                            <i class="bi bi-shield-check"></i>
                        </span>
                    <?php endif ?>
                </div>
            </a>

            <div class="card-body d-flex flex-column">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <div class="mentor_title text-truncate"><?php echo html_escape($mentor->name); ?></div>
                    <?php $code = get_by_id($mentor->country, 'country')->code; ?>
                    <div>
                        <img data-toggle="tooltip" data-placement="top" title="<?php echo get_by_id($mentor->country, 'country')->name; ?>" class="flag-cimg" src="<?php echo base_url('assets/images/flags/'.strtolower($code).'.png') ?>">
                    </div>
                </div>

                <div class="mb-3 fs-13">
                    <?php if (!empty($mentor->designation)): ?>
                        <span><i class="bi bi-briefcase"></i> <?php echo html_escape($mentor->designation) ?>
                    <?php endif ?> 
                    <?php if (!empty($mentor->company)): ?>
                        <span class="text-muted fw-500"><?php echo trans('at') ?></span> <?php echo html_escape($mentor->company) ?>.</span>
                    <?php endif ?>
                </div>
                
                <div class="mb-3 fs-13">
                    <i class="bi bi-tag"></i> 
                    <?php 
                        if (!empty($mentor->category)): 
                            $usrcategory = explode(',', $mentor->category);
                            $cname = array();
                            foreach($usrcategory as $uid){
                                $cname[] = get_by_id($uid, 'categories')->name;
                            }
                            echo implode(' · ', array_slice($cname, 0, 2));
                            if (count($cname) > 2) echo ' +' . (count($cname) - 2);
                        endif; 
                    ?> 
                </div>

                <div class="d-flex justify-content-between fs-12 mt-auto">
                    <div>
                        <p class="mb-0 fw-500 text-muted"><?php echo trans('experience') ?></p>
                        <p class="mt-0 mb-0 text-dark fs-16">
                            <?php if (empty($mentor->experience_year)): ?>
                                1 <?php echo trans('years') ?>
                            <?php else: ?>
                                <?php echo html_escape($mentor->experience_year); ?> <?php echo trans('years') ?>
                            <?php endif ?>
                        </p>
                    </div>
                    <?php if($mentor->minprice <= 0 &&  $mentor->maxprice <= 0){} else{ ?>
                    <div class="brr-1"></div>
                    <div>
                        <p class="mb-0 fw-500 text-muted"><?php echo trans('price') ?></p>
                        <p class="mt-0 mb-0 text-dark fs-16"><?php echo settings()->currency_symbol.' '.$mentor->minprice.' - '.$mentor->maxprice;?></p>
                    </div>
                    <?php }?>
                </div>
                
                <!--<div class="mt-3 text-center">-->
                <!--    <a href="<?php echo base_url('mentor/'. $mentor->slug) ?>" class="btn btn-primary-linear w-100 mentor-profile-link">-->
                <!--        View Profile <i class="bi bi-arrow-right-short" style="font-size: 1.25rem;"></i>-->
                <!--    </a>-->
                <!--</div>-->
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>