<!DOCTYPE html>
<html lang="en" dir="<?php echo text_dir(); ?>">

<head>

    <!-- Title  -->
    <?php $settings = get_settings(); ?>
    <title><?php echo html_escape($settings->site_name) ?> &bull; <?php if(isset($page_title)){echo trans(strtolower($page_title)).' &bull; ';} ?>  <?php echo html_escape($settings->site_title) ?></title>
    <!-- Metas -->
    <meta charset="utf-8">
    <?php if (isset($page) && $page == 'Mentor'): ?>
    <meta name="author" content="<?php if(!empty($mentor)){echo html_escape($mentor->name);} ?>">
    <meta name="description" content="<?php if(!empty($mentor)){echo html_escape($mentor->description);} ?>">
    <meta name="keywords" content="<?php if(!empty($mentor)){echo html_escape($mentor->keywords);} ?>">
    <?php else: ?>
    <meta name="author" content="<?php echo html_escape($settings->site_name) ?>">
    <meta name="description" content="<?php echo html_escape($settings->description) ?>">
    <meta name="keywords" content="<?php echo html_escape($settings->keywords) ?>">
    <?php endif ?>
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#2563eb" />
    <meta name="msapplication-navbutton-color" content="#2563eb" />
    <meta name="apple-mobile-web-app-status-bar-style" content="#2563eb" />

    <!-- Favicons-->
    <link rel="icon" href="<?php echo base_url($settings->favicon) ?>">
    <link rel="apple-touch-icon" href="<?php echo base_url($settings->favicon) ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo base_url($settings->favicon) ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo base_url($settings->favicon) ?>">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo base_url() ?>assets/img/favicon.ico">
   
    <!-- CSS Libs  -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/font-awesome/css/fontawesome-all.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/fonts/bootstrap/bootstrap-icons.css">

    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/sweet-alert.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/plugins/line-icons/lineicons.css">

    <!-- nice-select -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/nice-select.css">
    <!-- select2 -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/plugins/select2/css/select2.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/plugins/select2/css/select2.min.css">
    <!-- tagsinput -->
    <link href="<?php echo base_url() ?>assets/admin/css/bootstrap-tagsinput.css" rel="stylesheet" />
    <!-- Template CSS -->
    <link href="<?php echo base_url() ?>assets/front/css/template.css" rel="stylesheet">
    
    <?php if (settings()->front_layout == 2): ?>
        <link href="<?php echo base_url() ?>assets/front/css/template2.css" rel="stylesheet">
    <?php endif ?>

    <?php $homeCss = 'assets/front/css/home3.css'; ?>
    <link href="<?php echo base_url($homeCss) ?>?v=<?php echo filemtime(FCPATH . $homeCss); ?>" rel="stylesheet">

    <?php if(settings()->enable_animation == 1): ?>
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/aos.css">
    <?php endif; ?>  
    <!-- sweet alert -->
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/sweet-alert.css">

    

    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/css/owl.carousel.min.css">
    <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/css/owl.theme.default.min.css">

    <!-- overwrite css -->
    <?php $font = get_by_id(settings()->site_font,'fonts')->name; ?>
    <link href="https://fonts.googleapis.com/css?family=<?php echo str_replace(' ', '+', $font); ?>:400,500,600,700" rel="stylesheet">
    
    <?php if(isset($page_title) && $page_title == 'Home'): ?>
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/style-search.css">
    <?php endif; ?>

    <?php if (text_dir() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/custom-rtl.css">
        <link rel="stylesheet" href="<?php echo base_url()?>assets/admin/css/bootstrap-rtl.min.css" crossorigin="anonymous">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/admin/css/custom-ltr.css">
    <?php endif ?>

    <?php if (site_mode() == 'dark'): ?>
        <link rel="stylesheet" href="<?php echo base_url() ?>assets/front/css/dark.css">
    <?php endif ?>

    <?php $rgb = hex2rgb(settings()->site_color) ?>
    <link href="<?php echo base_url() ?>assets/front/css/style-over.php?color=<?php echo settings()->site_color; ?>&font=<?php echo str_replace(' ', '+', $font).'&rgb='.$rgb ?>" rel="stylesheet">

    <!-- csrf token -->
    <script type="text/javascript">
       var csrf_token = '<?= $this->security->get_csrf_hash(); ?>';
       var token_name = '<?= $this->security->get_csrf_token_name();?>';
    </script>
    
    <?php if (settings()->enable_captcha == 1 && settings()->captcha_site_key != ''): ?>
        <script src='https://www.google.com/recaptcha/api.js'></script>
    <?php endif; ?>

    <style type="text/css">
        <?php echo json_decode(settings()->custom_css) ?>
    </style>

    <?php if (settings()->enable_pwa == 1): ?>
        <?php include 'pwa_config.php'; ?>
    <?php endif ?>

    <?php if (!empty($settings->google_analytics)): ?>
        <script>
            <?php echo base64_decode($settings->google_analytics); ?>
        </script>
    <?php endif ?>

    <style>
        
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const logoTrack = document.querySelector('.logo-track');
            if (logoTrack) {
                const logos = logoTrack.innerHTML;
                logoTrack.innerHTML = logos + logos;
                
                const logoCount = document.querySelectorAll('.logo-marquee-item').length / 2;
                if (logoCount <= 3) {
                    logoTrack.innerHTML += logos;
                }
                
                const scrollSpeed = Math.max(20, logoCount * 4);
                logoTrack.style.animationDuration = scrollSpeed + 's';
            }
        });
    </script>
</head>

<body class="<?php if(site_mode() == 'dark'){echo "dark-mode";} ?>">
    <!-- main wrapper -->
    <div class="main-wrapper">

        <!-- header -->
        <?php if (isset($menu) && $menu == TRUE): ?>
            <header class="navbar navbar-expand-lg navbar-light bg-white fixed-top">
                <div class="container">
                    <a class="navbar-brand" href="<?php echo base_url() ?>">
                        <?php 
                            $logos = [];
                            if (!empty($settings->logos)) {
                                $logos = json_decode($settings->logos, true);
                            }
                        
                            if (!empty($logos)): 
                        ?>
                            <div class="logo-marquee">
                                <div class="logo-track">
                                    <?php foreach($logos as $logo): ?>
                                        <img src="<?php echo base_url($logo) ?>" alt="logo" class="logo-marquee-item">
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <img src="<?php echo base_url(settings()->logo) ?>" alt="logo">
                        <?php endif; ?>
                    </a>

                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarContent">
                        <span class="fas fa-bars"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarContent">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a class="nav-link <?php if(isset($page_title) && $page_title == "Home"){echo "active";} ?>" href="<?php echo base_url() ?>">
                                    <?php echo trans('home') ?>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link <?php if(isset($page_title) && $page_title == "Mentors"){echo "active";} ?>" href="<?php echo base_url('mentors') ?>">
                                    <?php echo trans('mentors') ?>
                                </a>
                            </li>
                            <?php if (settings()->enable_blog == 1): ?>
                                <li class="nav-item">
                                    <a class="nav-link <?php if(isset($page_title) && $page_title == "Blogs"){echo "active";} ?>" href="<?php echo base_url('blogs') ?>">
                                        <?php echo trans('blogs') ?>
                                    </a>
                                </li>
                            <?php endif ?>
                            <!--<li class="nav-item">-->
                            <!--    <a class="nav-link" target="_blank" href="https://app.ugrowthconsultancy.com/">-->
                            <!--        <?php echo trans('certified-consultant') ?>-->
                            <!--    </a>-->
                            <!--</li>-->
                            <!--<li class="nav-item">-->
                            <!--    <a class="nav-link" target="_blank" href="https://services.ugrowthconsultancy.com/">-->
                            <!--        <?php echo trans('services') ?>-->
                            <!--    </a>-->
                            <!--</li>-->
                        </ul>
                        
                        <div class="navbar-nav ms-auto">
                            <?php if (is_admin()): ?>
                                <div class="nav-action-buttons">
                                    <a class="btn btn-outline-secondary" href="<?php echo base_url('auth/logout') ?>">
                                        <i class="lni lni-exit mr-1"></i> <?php echo trans('logout') ?>
                                    </a>
                                    <a class="btn btn-primary" href="<?php echo base_url('admin/dashboard') ?>">
                                        <i class="bi bi-speedometer2 mr-1"></i> <?php echo trans('dashboard') ?>
                                    </a>
                                </div>
                            <?php elseif(is_mentee()): ?>
                                <div class="nav-action-buttons">
                                    <a class="btn btn-sm btn-secondary ml-auto" href="<?php echo base_url('auth/logout') ?>"><i class="lni lni-exit"></i> <?php echo trans('logout') ?> </a>
                                    <a class="btn btn-primary" href="<?php echo base_url('admin/dashboard/mentee') ?>">
                                        <i class="bi bi-person mr-1"></i> My Account
                                    </a>
                                </div>
                            <?php elseif(is_user()): ?>
                                <div class="nav-action-buttons">
                                    <a class="btn btn-sm btn-secondary ml-auto" href="<?php echo base_url('auth/logout') ?>"><i class="lni lni-exit"></i> <?php echo trans('logout') ?> </a>
                                    <a class="btn btn-primary" href="<?php echo base_url('admin/dashboard/user') ?>">
                                        <i class="bi bi-person mr-1"></i> My Account
                                    </a>
                                </div>
                            <?php else: ?>
                                <div class="nav-action-buttons">
                                    <a class="btn btn-outline-secondary" href="<?php echo base_url('login') ?>">
                                        <?php echo trans('sign-in') ?>
                                    </a>
                                    <a class="btn btn-primary" href="<?php echo base_url('register') ?>">
                                        <?php echo trans('get-started') ?>
                                    </a>
                                </div>
                            <?php endif ?>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Mentor Categories Navigation -->
            <?php if (isset($page_title) && ($page_title == "Home" || $page_title == "Mentors")): ?>
            <div class="mentor-categories-nav">
                <div class="container">
                    <div class="mentor-nav-wrapper">
                        <ul class="mentor-nav-list">
                            <?php foreach($categories as $category): ?>
                                <li class="mentor-nav-item">
                                    <a href="<?php echo base_url('mentors?category='.$category->id) ?>" class="mentor-nav-link">
                                        <?php echo $category->name ?> Mentors
                                    </a>
                                </li>
                            <?php endforeach; ?>
                            <li class="mentor-nav-item">
                                <a href="<?php echo base_url('mentors') ?>" class="mentor-nav-link">
                                    Top Mentors
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        <?php endif ?>

