    <!-- Footer -->
    <?php if (isset($menu) && $menu == TRUE): ?>
        <footer class="footer bg-white">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 mb-5 mb-lg-0">
                        <div class="footer-brand mb-4">
                            <img src="<?php echo base_url(settings()->logo) ?>" alt="logo" height="40">
                        </div>
                        <p class="footer-text mb-4"><?php echo html_escape(settings()->footer_about) ?></p>
                        <div class="footer-social">
                            <?php if (!empty($settings->facebook)) : ?>
                                <a href="<?= prep_url($settings->facebook) ?>" class="footer-social-link" target="_blank" aria-label="Facebook">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            <?php endif ?>
                            <?php if (!empty($settings->twitter)) : ?>
                                <a href="<?= prep_url($settings->twitter) ?>" class="footer-social-link" target="_blank" aria-label="Twitter">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            <?php endif ?>
                            <?php if (!empty($settings->linkedin)) : ?>
                                <a href="<?= prep_url($settings->linkedin) ?>" class="footer-social-link" target="_blank" aria-label="LinkedIn">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            <?php endif ?>
                            <?php if (!empty($settings->instagram)) : ?>
                                <a href="<?= prep_url($settings->instagram) ?>" class="footer-social-link" target="_blank" aria-label="Instagram">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            <?php endif ?>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-4 mb-4 mb-md-0">
                        <h3 class="footer-heading"><?php echo trans('services') ?></h3>
                        <ul class="footer-links">
                            <li>
                                <a href="<?php echo base_url('mentors') ?>"><?php echo trans('mentors') ?></a>
                            </li>
                            <?php if (settings()->enable_blog == 1): ?>
                                <li>
                                    <a href="<?php echo base_url('blogs') ?>"><?php echo trans('blogs') ?></a>
                                </li>
                            <?php endif; ?>
                            <?php if (settings()->enable_faq == 1): ?>
                                <li>
                                    <a href="<?php echo base_url('faqs') ?>"><?php echo trans('faqs') ?></a>
                                </li>
                            <?php endif; ?>
                            <li>
                                <a href="<?php echo base_url('contact') ?>"><?php echo trans('contact') ?></a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-4 col-md-4 mb-4 mb-md-0">
                        <?php if (!empty(get_pages(0, 'admin', 1))): ?>
                            <h3 class="footer-heading"><?php echo trans('pages') ?></h3>
                            <ul class="footer-links">
                                <?php foreach (get_pages(0, 'admin', 1) as $page): ?>
                                    <li>
                                        <a href="<?php echo base_url('page/'.$page->slug) ?>"><?php echo html_escape($page->title) ?></a>
                                    </li>
                                <?php endforeach ?>
                            </ul>
                        <?php endif ?>
                    </div>
                    <!--<div class="col-lg-4 col-md-4">-->
                    <!--    <h3 class="footer-heading"><?php echo trans('newsletter') ?></h3>-->
                    <!--    <p class="footer-text mb-4">Stay updated with the latest mentorship opportunities and career growth tips.</p>-->
                    <!--    <form class="newsletter-form" action="#">-->
                    <!--        <div class="newsletter-input-group">-->
                    <!--            <input type="email" class="newsletter-input" placeholder="Enter your email address">-->
                    <!--            <button class="newsletter-button" type="submit" aria-label="Subscribe">-->
                    <!--                <i class="fas fa-paper-plane"></i>-->
                    <!--            </button>-->
                    <!--        </div>-->
                    <!--    </form>-->
                    <!--</div>-->
                </div>
                <!--<div class="footer-bottom">-->
                <div>
                    <div class="row align-items-center">
                        <div class="col-12 text-center text-md-start">
                            <p class="copyright mb-0"><?php echo html_escape(settings()->copyright) ?></p>
                        </div>
                        <!--<div class="col-md-6 text-center text-md-end">-->
                        <!--    <ul class="footer-bottom-links">-->
                        <!--        <li>-->
                        <!--            <a href="<?php echo base_url('privacy-policy') ?>">Privacy Policy</a>-->
                        <!--        </li>-->
                        <!--        <li>-->
                        <!--            <a href="<?php echo base_url('page/terms-and-condition') ?>">Terms and Condition</a>-->
                        <!--        </li>-->
                        <!--    </ul>-->
                        <!--</div>-->
                    </div>
                </div>
            </div>
        </footer>
    <?php endif; ?>
    

    <!-- End Footer -->

    </div>

    <!--<?php if (settings()->enable_pwa == 1): ?>-->
    <!--    <a class="btn btn-primary bg-primary-soft" id="installPwa" href="#" style="display: none">-->
    <!--        <i class="bi bi-arrow-down-circle-fill fs-15"></i> Install PWA-->
    <!--    </a>-->
    <!--<?php endif; ?>-->

    <?php include'js_msg_list.php'; ?>

    <input type="hidden" id="base_url" value="<?php echo base_url(); ?>">
    <?php $success = $this->session->flashdata('msg'); ?>
    <?php $error = $this->session->flashdata('error'); ?>

    <input type="hidden" id="success" value="<?php if(isset($success)){echo html_escape($success);} ?>">
    <input type="hidden" id="error" value="<?php if(isset($error)){echo html_escape($error);} ?>">  
    <input type="hidden" id="cp" value="<?php echo strlen(settings()->purchase_code);?>">
    <a href="javascript:void(0)" class="scroll-to-top"><i class="fa fa-angle-up"></i></a>
    <input type="hidden" class="accept_cookies" value="<?php echo trans('accept_cookies') ?>">
    <input type="hidden" class="accept" value="<?php echo trans('accept') ?>">
    <input type="hidden" id="country_code" value="<?php echo strtolower(settings()->code); ?>">
    <input type="hidden" id="lan_type" value="<?php echo text_dir(); ?>">

    <!-- Global JS -->
    <script src="<?php echo base_url() ?>assets/front/libs/jquery/dist/jquery.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/popper.js/dist/umd/popper.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/bootstrap/dist/js/bootstrap.min.js"></script>
    
    <!-- owl carousel js -->
    <script src="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/js/owl.carousel.min.js"></script>
    <script src="<?php echo base_url() ?>assets/admin/js/sweet-alert.js"></script>
    <!-- nice select js -->
    <script src="<?php echo base_url()?>assets/admin/js/nice-select.min.js"></script>
    <script src="<?php echo base_url()?>assets/admin/plugins/select2/js/select2.full.min.js"></script>
    <script>
    window.onload = function() {
        $("#rcategory").select2({
            maximumSelectionLength: 3,
            formatSelectionTooBig: function (limit) {
                return 'Too many selected items';
            }
        });
    }
</script>
    <!-- tagsinput js -->
    <script src="<?php echo base_url() ?>assets/admin/js/bootstrap-tagsinput.js"></script>
    <!-- animation js -->
    <?php if(settings()->enable_animation == 1): ?>
        <script src="<?php echo base_url() ?>assets/front/js/aos.js"></script>
    <?php endif; ?>
    <!-- moment js -->
    <script src="<?php echo base_url() ?>assets/front/js/moment.min.js"></script>
    <!-- Custom JS -->
    <script type="text/javascript" src="<?php echo base_url() ?>assets/front/js/custom.js?var=<?= settings()->version ?>&time=<?=time();?>"></script>
    <!-- stripe js -->
    <?php $this->load->view('admin/include/stripe-js.php');?>

    <?php if(isset($page_title) && $page_title == 'Booking' || $page_title == 'Profile'): ?>
        <script src="<?php echo base_url() ?>assets/admin/js/jquery-ui.min.js"></script>
        <?php $this->load->view('include/datepicker-js.php');?>
    <?php endif; ?>

    <?php if (settings()->enable_pwa == 1): ?>
        <?php include 'pwa_footer_js.php'; ?>
    <?php endif; ?>

</body>


</html>
