<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="content-wrapper">
    <div class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-md-10">
                    <div class="card shadow-sm mt-5">
                        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center px-3">
                            <h4 class="mb-0"><i class="fas fa-upload mr-2"></i>Import Mentors</h4>
                            <div>
                                <a href="<?php echo base_url('admin/users/download_mentor_template/csv'); ?>" class="btn btn-sm btn-outline-light mr-2"><i class="fas fa-file-csv mr-1"></i>CSV Sample</a>
                                <a href="<?php echo base_url('admin/users/download_mentor_template/excel'); ?>" class="btn btn-sm btn-outline-light"><i class="fas fa-file-excel mr-1"></i>Excel Sample</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if ($this->session->flashdata('error')): ?>
                                <div class="alert alert-danger"> <?php echo $this->session->flashdata('error'); ?> </div>
                            <?php endif; ?>
                            <?php if ($this->session->flashdata('msg')): ?>
                                <div class="alert alert-success"> <?php echo $this->session->flashdata('msg'); ?> </div>
                            <?php endif; ?>
                            <?php 
                            $csrf_token_name = isset($GLOBALS['CI']) && isset($GLOBALS['CI']->security) ? $GLOBALS['CI']->security->get_csrf_token_name() : (function(){ $CI =& get_instance(); return $CI->security->get_csrf_token_name(); })();
                            $csrf_hash = isset($GLOBALS['CI']) && isset($GLOBALS['CI']->security) ? $GLOBALS['CI']->security->get_csrf_hash() : (function(){ $CI =& get_instance(); return $CI->security->get_csrf_hash(); })();
                            ?>
                            <form method="post" enctype="multipart/form-data" action="<?php echo base_url('admin/users/import_mentors'); ?>" class="dropzone" id="mentor-import-form">
                                <input type="hidden" name="<?php echo $csrf_token_name; ?>" value="<?php echo $csrf_hash; ?>">
                                <div class="form-group text-center">
                                    <label for="import_file" class="w-100 mb-3">
                                        <div class="dz-message needsclick">
                                            <i class="fas fa-cloud-upload-alt fa-3x text-primary mb-2"></i>
                                            <h5>Click to select your CSV or Excel file.</h5>
                                            <small class="text-muted">Accepted: .csv, .xlsx, .xls | Max 5MB</small>
                                        </div>
                                    </label>
                                    <input type="file" name="import_file" id="import_file" class="form-control-file import-file-input" accept=".csv,.xlsx,.xls" required>
                                </div>
                                <div class="form-group text-center mt-4">
                                    <button type="submit" class="btn btn-primary btn-lg px-5"><i class="fas fa-upload mr-2"></i>Import Mentors</button>
                                </div>
                            </form>
                            <div class="mt-4">
                                <h6 class="font-weight-bold">Instructions:</h6>
                                <ul class="text-muted">
                                    <li>Download the sample file and fill in your mentor data.</li>
                                    <li>Do not change the column headers in the sample file.</li>
                                    <li>Accepted file types: CSV, XLSX, XLS. Max 100 records per import.</li>
                                    <li>Required fields: Name, Email, Password.</li>
                                    <li>Country: Use country ID from your system (see Settings &gt; Country).</li>
                                    <li>Category: Use category IDs separated by comma for multiple categories (e.g., "1,3,5").</li>
                                    <li>All imported mentors will be set to Active status by default.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
const importFileInput = document.getElementById('import_file');
const form = document.getElementById('mentor-import-form');
const dzMessage = form.querySelector('.dz-message');
const submitBtn = form.querySelector('button[type="submit"]');

importFileInput.addEventListener('change', function() {
    if (importFileInput.files.length > 0) {
        dzMessage.querySelector('h5').textContent = importFileInput.files[0].name;
    }
});

form.addEventListener('submit', function(e) {
    if (importFileInput.files.length === 0) {
        e.preventDefault();
        return;
    }
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm mr-2" role="status" aria-hidden="true"></span>Importing...';
    let warn = document.getElementById('import-warning');
    if (!warn) {
        warn = document.createElement('div');
        warn.id = 'import-warning';
        warn.className = 'alert alert-warning mt-3';
        warn.innerHTML = '<b>Do not close or refresh this window until the import is complete.</b>';
        form.parentNode.insertBefore(warn, form.nextSibling);
    }
});
</script>
<style>
    .card-header.bg-primary {
        background: linear-gradient(90deg, #4A6CF7 0%, #3578e5 100%) !important;
    }
    .dz-message { cursor: pointer; border: 2px dashed #4A6CF7; border-radius: 10px; padding: 40px 10px; background: #f8faff; transition: border-color 0.2s; }
    .dz-message:hover { border-color: #3578e5; }
    .import-file-input {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        opacity: 0;
        cursor: pointer;
        z-index: 2;
    }
    .form-group.text-center { position: relative; }
</style>
