<div class="content-wrapper">

  <!-- Content Header (Page header) -->
  <?php $this->load->view('admin/include/breadcrumb'); ?>

  <!-- Main content -->
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">

          <div class="card add_area <?php if (isset($page_title) && $page_title == "Edit") {
                                      echo "d-block";
                                    } else {
                                      echo "hide";
                                    } ?>">

            <div class="card-header">
              <?php if (isset($page_title) && $page_title == "Edit") : ?>
                <h3 class="card-title pt-2"><?php echo trans('edit') ?></h3>
              <?php else : ?>
                <h3 class="card-title pt-2"><?php echo trans('create-new') ?> </h3>
              <?php endif; ?>

              <div class="card-tools pull-right">
                <?php if (isset($page_title) && $page_title == "Edit") : ?>
                  <?php $required = ''; ?>
                  <a href="<?php echo base_url('admin/country') ?>" class="pull-right btn btn-secondary btn-sm"><i class="lni lni-arrow-left"></i> <?php echo trans('back') ?></a>
                <?php else : ?>
                  <?php $required = 'required'; ?>
                  <a href="#" class="text-right btn btn-secondary btn-sm cancel_btn"><i class="fa lni lni-arrow-left"></i> <?php echo trans('back') ?></a>
                <?php endif; ?>
              </div>
            </div>
            <div class="col-lg-8">
               <?php if ($success): ?>
                    <div class="alert bg-success-soft brd-2" role="alert"><?php echo $success ?></div>
                <?php endif; ?>
                <?php if ($error): ?>
                    <div class="alert bg-danger-soft brd-2" role="alert"><?php echo $error ?></div>
                <?php endif; ?>

              <form method="post" enctype="multipart/form-data" class="validate-form" action="<?php echo base_url('admin/certificates/add') ?>" role="form">
                <div class="card-body">
                  <div class="form-group validate">
                    <label><?php echo trans('mentee') ?> <span class="text-danger">*</span></label>
                    <select class="form-control" name="mentee" aria-invalid="false" id="mentee_list" required>
                      <option value=""><?php echo trans('select') ?></option>
                      <?php foreach ($mentees as $mentee) : ?>
                        <option value="<?php echo html_escape($mentee->id); ?>"><?php echo html_escape($mentee->name); ?></option>
                      <?php endforeach ?>
                    </select>
                  </div>
                  <div class="form-group validate">
                    <label><?php echo trans('session-booking') ?><span class="text-danger">*</span></label>
                    <select name="sessionbooking" class="form-control" id="sessionbooking" required>
                    <option value=""><?php echo trans('no-session-found'); ?></option>
                    </select>
                  </div>
                  <div class="form-group validate">
                    <label><?php echo trans('certificates') ?><span class="text-danger">*</span></label>
                    <div class="custom-file mt-2 validate">
                      <input type="file" class="custom-file-input" required name="certificates" id="certificates" accept="application/pdf">
                      <label class="custom-file-label" for="certificates"><?php echo trans('upload-certificates') ?></label>
                    </div>
                  </div>
                  <div class="form-group validate">
                    <label><?php echo trans('takeaways') ?><span class="text-danger">*</span></label>
                    <div class="custom-file mt-2 validate">
                      <input type="file" class="custom-file-input" required name="takeaways" id="takeaways" accept="application/pdf">
                      <label class="custom-file-label" for="takeaways"><?php echo trans('upload-session-takeaways') ?></label>
                    </div>
                  </div>
                   <div class="form-group">
                    <label><?php echo trans('session-report') ?><span class="text-danger">*</span></label>
                    <div class="custom-file mt-2 reportsess">
                    <textarea rows="2" name="" class="form-control" autocomplete="off" disabled></textarea>
                    </div>
                  </div>
                </div>
                <div class="card-footer">
                  <input type="hidden" name="id" value="<?php //if (isset($country->id)) { echo html_escape($country->id); } ?>">
                  <!-- csrf token -->
                  <input type="hidden" name="<?php echo html_escape($this->security->get_csrf_token_name()); ?>" value="<?php echo html_escape($this->security->get_csrf_hash()); ?>">

                  <?php if (isset($page_title) && $page_title == "Edit") : ?>
                    <button type="submit" class="btn btn-primary pull-left"><?php echo trans('save-changes') ?></button>
                  <?php else : ?>
                    <button type="submit" class="btn btn-primary pull-left"> <?php echo trans('save') ?></button>
                  <?php endif; ?>
                </div>

              </form>
            </div>
          </div>


          <?php if (isset($page_title) && $page_title != "Edit") : ?>
            <div class="card list_area">

              <div class="card-header">
                <?php if (isset($page_title) && $page_title == "Edit") : ?>
                  <h3 class="card-title pt-2"><?php echo trans('edit') ?> <a href="<?php echo base_url('admin/pages') ?>" class="pull-right btn btn-secondary btn-sm"><i class="lni lni-arrow-left"></i> <?php echo trans('back') ?></a></h3>
                <?php else : ?>
                  <h3 class="card-title pt-2"><?php echo trans('certificates') ?></h3>
                <?php endif; ?>

                <div class="card-tools pull-right">
                  <a href="#" class="pull-right btn btn-secondary btn-sm add_btn"><i class="fas fa-plus"></i> <?php echo trans('create-new') ?></a>
                </div>
              </div>
              <?php if (!empty($certificates)) : ?>
                <div class="card-body table-responsive p-0">
                  <table class="table table-hover text-nowrap <?php if (count($certificates) > 10) {
                                                                echo "datatable";
                                                              } ?>">
                    <thead>
                      <tr>
                        <th>#</th>
                        <th><?php echo trans('user') ?></th>
                        <th><?php echo trans('mentor') ?></th>
                        <th><?php echo trans('session') ?></th>
                        <th><?php echo trans('booking-number') ?></th>
                        <th><?php echo trans('certificates') ?></th>
                        <th><?php echo trans('takeaways') ?></th>
                        <th><?php echo trans('action') ?></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $i = 1;
                      foreach ($certificates as $certificate) : ?>
                        <tr id="row_<?php echo ($certificate->id); ?>">
                          <td><?= $i; ?></td>
                          <td><?php echo html_escape($this->admin_model->get_by_id($certificate->userId, 'users')->name); ?></td>
                          <td><?php echo html_escape($certificate->uname); ?></td>
                          <td><?php echo html_escape($this->admin_model->get_by_id($certificate->sessionsId, 'sessions')->name); ?></td>
                          <td><?php echo html_escape($this->admin_model->get_by_id($certificate->booking_number, 'session_booking')->booking_number); ?></td>
                          <td><a href="<?php echo base_url($certificate->certificates); ?>" target="_blank">View</a></td>
                          <td><a href="<?php echo base_url($certificate->takeaways); ?>" target="_blank">View</a></td>
                          <td class="actions">
                          <div class="btn-group">
                            <button type="button" class="btn btn-tool" data-toggle="dropdown" aria-expanded="false">
                              <i class="fas fa-ellipsis-h"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right" role="menu" >
                            <a data-val="Category" data-id="<?php echo html_escape($certificate->id); ?>" href="<?php echo base_url('admin/certificates/delete/'.html_escape($certificate->id));?>" class="dropdown-item delete_item"><i class="bi bi-trash3 mr-1"></i><?php echo trans('delete') ?></a>
                            </div>
                          </div>
                          </td>
                        </tr>
                      <?php $i++;
                      endforeach; ?>
                    </tbody>
                  </table>
                </div>
              <?php else : ?>
                <?php $this->load->view('admin/include/not-found'); ?>
              <?php endif; ?>

            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>