<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class SearchExtension extends CI_Model {

    /**
     * Gets search results with extended capabilities (searches through skills, keywords, and more fields)
     */
    function get_extended_search_results($search_term)
    {
        if (empty($search_term)) {
            return array();
        }
        
        $this->db->select('u.*, (SELECT COUNT(*) FROM session_booking sb WHERE sb.user_id = u.id AND sb.status = 3) as completed_sessions', FALSE);
        $this->db->from('users u');
        $this->db->join('users_skill as us', 'u.id = us.user_id', 'LEFT');
        $this->db->join('skills as s', 'us.skill_id = s.id', 'LEFT');
        $this->db->join('mentors_settings_extra as ms', 'ms.user_id = u.id', 'LEFT');
        $this->db->join('categories as c', 'find_in_set(c.id , u.category) > 0', 'LEFT');
        $this->db->where('u.role', 'user');
        $this->db->where('u.status', 1);
        
        $this->db->group_start();
        $this->db->like('u.name', $search_term);
        $this->db->or_like('u.user_name', $search_term);
        $this->db->or_like('u.language', $search_term);
        $this->db->or_like('u.company', $search_term);
        $this->db->or_like('u.designation', $search_term);
        $this->db->or_like('u.skill', $search_term);
        // $this->db->or_like('u.about_me', $search_term);
        // $this->db->or_like('u.description', $search_term);
        $this->db->or_like('s.skill', $search_term);
        $this->db->or_like('c.name', $search_term);
        $this->db->or_like('ms.keywords', $search_term);
        $this->db->group_end();
        
        $this->db->group_by('u.id');
        $this->db->order_by('completed_sessions', 'DESC');
        
        $query = $this->db->get();
        return $query->result();
    }
    
    /**
     * Count search results with extended capabilities
     */
    function count_extended_search_results($search_term)
    {
        if (empty($search_term)) {
            return 0;
        }
        
        $this->db->select('COUNT(DISTINCT u.id) as count', FALSE);
        $this->db->from('users u');
        $this->db->join('users_skill as us', 'u.id = us.user_id', 'LEFT');
        $this->db->join('skills as s', 'us.skill_id = s.id', 'LEFT');
        $this->db->join('mentors_settings_extra as ms', 'ms.user_id = u.id', 'LEFT');
        $this->db->join('categories as c', 'find_in_set(c.id , u.category) > 0', 'LEFT');
        $this->db->where('u.role', 'user');
        $this->db->where('u.status', 1);
        
        $this->db->group_start();
        $this->db->like('u.name', $search_term);
        $this->db->or_like('u.user_name', $search_term);
        $this->db->or_like('u.language', $search_term);
        $this->db->or_like('u.company', $search_term);
        $this->db->or_like('u.designation', $search_term);
        $this->db->or_like('u.skill', $search_term);
        // $this->db->or_like('u.about_me', $search_term);
        // $this->db->or_like('u.description', $search_term);
        $this->db->or_like('s.skill', $search_term);
        $this->db->or_like('c.name', $search_term);
        $this->db->or_like('ms.keywords', $search_term);
        $this->db->group_end();
        
        $query = $this->db->get();
        $result = $query->row();
        return $result->count;
    }
}