<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Certificates extends Home_Controller {

    public function __construct()
    {
        parent::__construct();
        if (!is_admin()) {
            redirect(base_url());
        }
    }

    public function index()
    {
        $data = array();
        $data['page_title'] = 'Certificates';
        $data['page'] = 'Certificates';
        $total_row = $this->admin_model->get_all_certificates('',$total=1, 0, 0);
        $config['total_rows'] = $total_row;
        $config['per_page'] = 10 ;
        $this->pagination->initialize($config);
        $page = $this->security->xss_clean($this->input->get('page'));
        if (empty($page)) {
            $page = 0;
        }
        if ($page != 0) {
            $page = $page - 1;
        }
        $data['certificates']=$this->admin_model->get_all_certificates('',$total=0, $config['per_page'], $page * $config['per_page']);
        $data['mentees'] = $this->admin_model->get_mentee_certificates();
        $data['main_content'] = $this->load->view('admin/certificates',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    public function sessionbooking(){
        $user_id = $this->input->post('id');
        $data = array();
        $data['session'] = $this->admin_model->get_mentee_certificates_not_print($user_id);
        $loaded=$this->load->view('admin/include/certificates_session',$data,true);
        echo json_encode(array('st'=> 1, 'loaded'=> $loaded));
    }
    
     public function sessionreport(){
        $session_id = $this->input->post('sid');
        $data = array();
        $data['session'] = $this->admin_model->get_mentee_certificates_report($session_id);
        $loaded=$this->load->view('admin/include/certificatesreport',$data,true);
        echo json_encode(array('st'=> 1, 'loaded'=> $loaded));
    }
    
    public function add()
    { 
        check_status();
        if($_POST)
        {   
            $mentee = $this->input->post('mentee', true);
            $id = $this->input->post('id', true);
            $session=$this->input->post('sessionbooking', true);
            $sesexplode=explode('||',$session);
            $sid=$sesexplode[0];
            $sbid=$sesexplode[1];

            if(empty($mentee)){
                $this->session->set_flashdata('error', 'Please select a mentee');
            }

            $data=array(
                'createdby' =>user()->id,
                'booking_number' => $sbid,
                'sessionsId' => $sid,
                'userId ' => $mentee
            );
            $data = $this->security->xss_clean($data);
            if ($id != '') {
                $this->admin_model->edit_option($data, $id, 'certificates');
                $this->session->set_flashdata('msg', trans('updated-successfully')); 
            } else {
                $id = $this->admin_model->insert($data, 'certificates');
                $this->session->set_flashdata('msg', trans('inserted-successfully')); 
            }
            if($_FILES['certificates']['name'] != '' && $_FILES['takeaways']['name'] != ''){
                $new_name = "file_".strtolower(time().'2.'.pathinfo($_FILES['certificates']['name'], PATHINFO_EXTENSION));
                $config['upload_path']          = './uploads/files'; //file save path
                $config['allowed_types']        = 'pdf';
                $config['max_size']             = 10000;
                $config['encrypt_name']          = TRUE;
                $config['file_name'] = $new_name;

                $this->load->library('upload', $config);
                if ( ! $this->upload->do_upload('certificates'))
                {   
                    $error = array('error' => $this->upload->display_errors());
                    $this->session->set_flashdata('error', $error);
                }else{
                    $filedata = $this->upload->data();
                    $file_name = $filedata['file_name'];
            
                    $filedata=array(
                        'certificates' => 'uploads/files/'.$file_name
                    );   
                    $filedata = $this->security->xss_clean($filedata);
                    $this->admin_model->edit_option($filedata, $id,'certificates');
                }

                $new_name2 = "file_".strtolower(time().'2.'.pathinfo($_FILES['takeaways']['name'], PATHINFO_EXTENSION));
                $config['file_name'] = $new_name2;

                $this->load->library('upload', $config);
                if ( ! $this->upload->do_upload('takeaways'))
                {   
                    $error = array('error' => $this->upload->display_errors());
                    $this->session->set_flashdata('error', $error);
                }else{
                    $filedata2 = $this->upload->data();
                    $file_name2 = $filedata2['file_name'];
                    $filedata2=array(
                        'takeaways' => 'uploads/files/'.$file_name2
                    );
                    
                    $filedata2 = $this->security->xss_clean($filedata2);
                    $this->admin_model->edit_option($filedata2, $id,'certificates');
                }
                
            }else{
                $this->session->set_flashdata('error', 'Please Upload Certificate');
            }
            redirect(base_url('admin/certificates'));
        }   
    }

    public function delete($id)
    {
        $this->admin_model->delete($id,'certificates'); 
        echo json_encode(array('st' => 1));
    }
}
    

